/*
 * Castaway
 *  (C) 1994 - 2002 Joachim Hoenig, Martin Doering
 *
 * This file is distributed under the GPL, version 2 or at your
 * option any later version.  See doc/license.txt for details.
 */
#ifndef CONFIGH
#define CONFIGH
/*
 * Environment Configuration
 */

#ifdef __GNUC__
#ifndef INLINE
#define INLINE static inline
#endif
#endif
#ifdef __BORLANDC__
#define INLINE __inline
#endif

/*
 * compiler representation of M68000 .B .W .L operands
 */
typedef signed char     int8;
typedef signed short    int16;
typedef signed long     int32;
typedef unsigned char   uint8;
typedef unsigned short  uint16;
typedef unsigned long   uint32;

#define CHKADDRESSERR       /* if set, unaligned access will raise
                             * an address error (slower, but
                             * expected behaviour) */

#undef DEBUG                /* Debug */

// musashi compatibility macros

#define get_pc m68k_get_reg(NULL,M68K_REG_PC)
#define GetS() (m68k_get_reg(NULL,M68K_REG_SR)&0x2000)
#define BUSERR
#define ExceptionGroup0(A,B,C)
#define ExceptionGroup1(A,B,C)


extern int ask_bkpt;

/*
 * Debug options
 */
#ifdef DEBUG
#define CHKADDRESSERR       /* force address error checking */
#define ON_TRAP(number)
#define ON_UNMAPPED(address, value)
#define ON_NOIO(address, value)
#define ON_WRITE(address, value)

extern char *log_box;
extern char *mmu_box;

#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#define WARN0(A) {strcat(log_box,A);strcat(log_box,"\n");}
#define WARN1(A,B) {char kbuf[256];sprintf(kbuf,A,(B));strcat(log_box,kbuf);strcat(log_box,"\n");}
#define WARN2(A,B,C) {char kbuf[256];sprintf(kbuf,A,(B),(C));strcat(log_box,kbuf);strcat(log_box,"\n");}
#define TRACE0(A) {strcat(log_box,A);strcat(log_box,"\n");}
#define TRACE1(A,B) {char kbuf[256];sprintf(kbuf,A,(B));strcat(log_box,kbuf);strcat(log_box,"\n");}
#define TRACE2(A,B,C) {char kbuf[256];sprintf(kbuf,A,(B),(C));strcat(log_box,kbuf);strcat(log_box,"\n");}
#define TRACE3(A,B,C,D) {char kbuf[256];sprintf(kbuf,A,(B),(C),(D));strcat(log_box,kbuf);strcat(log_box,"\n");}
#ifdef _LISA_DEBUG_
#define DEBUG0(A) {strcat(log_box,A);strcat(log_box,"\n");}
#define DEBUG1(A,B) {char kbuf[256];sprintf(kbuf,A,(B));strcat(log_box,kbuf);strcat(log_box,"\n");}
#define DEBUG2(A,B,C) {char kbuf[256];sprintf(kbuf,A,(B),(C));strcat(log_box,kbuf);strcat(log_box,"\n");}
#else
#define DEBUG0(A)
#define DEBUG1(A,B)
#define DEBUG2(A,B,C)
#endif

#else /* not DEBUG */
#include "debug/trace.h"
#define CHKADDRESSERR       /* force address error checking */
#define ON_TRAP(number)
#define ON_UNMAPPED(address, value)
#define ON_NOIO(address, value)
#define ON_WRITE(address, value)
extern char *log_box;
extern char *mmu_box;
#define DEBUG0(A)
#define DEBUG1(A,B)
#define DEBUG2(A,B,C)
#define WARN0(A)
#define WARN1(A,B)
#define WARN2(A,B,C)
#define TRACE0(A)
#define TRACE1(A,B)
#define TRACE2(A,B,C)
#define TRACE3(A,B,C,D)
#endif
#endif /* CONFIGH */

